/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

!!! XXX DOES *NOT* USE BUILT-IN DETECTION FUNCTION XXX !!!

alert ip $EXTERNAL_NET any -> 224.0.0.0/4 any (msg:"DOS Microsoft PGM fragment denial of service attempt"; ip_proto: 113; content:"|04 01|"; depth: 2; offset: 4; metadata: policy balanced-ips drop, policy security-ips drop; reference: cve, 2008-1441; classtype:attempted-dos; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-036; sid:13825; rev:1; )

 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_WRAP(code) code
#else
#define DEBUG_WRAP(code)
#endif


/* declare detection functions */
int rule13825eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
// ip_proto:113;
static HdrOptCheck rule13825ip_proto0 =
{
    IP_HDR_PROTO,
    CHECK_EQ,
    113,
    0,
    0
};

static RuleOption rule13825option0 =
{
    OPTION_TYPE_HDR_CHECK,
    {
        &rule13825ip_proto0
    }
};
// content:"|04 01|", offset 4, depth 2; 
static ContentInfo rule13825content1 = 
{
    (uint8_t *) "|04 01|", /* pattern (now in snort content format) */
    2, /* depth */
    4, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13825option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13825content1
    }
};

/* references for sid 13825 */
/* reference: cve "2008-1441"; */
static RuleReference rule13825ref1 = 
{
    "cve", /* type */
    "2008-1441" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-036"; */
static RuleReference rule13825ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-036" /* value */
};

static RuleReference *rule13825refs[] =
{
    &rule13825ref1,
    &rule13825ref2,
    NULL
};

/* metadata for sid 13825 */
/* metadata:policy balanced-ips drop, policy security-ips drop; */

//static RuleMetaData rule13825policy1 = 
//{
//    "policy balanced-ips drop"
//};

//static RuleMetaData rule13825policy2 = 
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule13825policy3 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule13825metadata[] =
{
//    &rule13825policy1,
//    &rule13825policy2,
    &rule13825policy3,
    NULL
};

RuleOption *rule13825options[] =
{
    &rule13825option0,
    &rule13825option1,
    NULL
};

Rule rule13825 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_IP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "224.0.0.0/4", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13825, /* sigid */
       9, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft PGM fragment denial of service attempt",     /* message */
       rule13825refs /* ptr to references */
       ,rule13825metadata
   },
   rule13825options, /* ptr to rule options */
   &rule13825eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13825eval(void *p) {
   const uint8_t *cursor_normal = 0, *end_of_payload, *beg_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   uint32_t frag_off, total_len;

   DEBUG_WRAP(printf("pgm fragment dos\n"));
   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // ip_proto:113;
   if (checkHdrOpt(p, rule13825options[0]->option_u.hdrData) <= 0)
      return RULE_NOMATCH;

   // content:"|04 01|", offset 4, depth 2;
   if (contentMatch(p, rule13825options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   if(end_of_payload - beg_of_payload < 44)
      return RULE_NOMATCH; 

   // skip header stuff
   cursor_normal += 18;

   // Look for IPT_FRAGMENT, 16 bytes is size of OPT_FRAGMENT
   while(cursor_normal + 16 < end_of_payload) {
      if((*cursor_normal == 0x01) || (*cursor_normal == 0x81)) { 
         // Extract values
         frag_off = read_big_32(cursor_normal + 8);

         total_len = read_big_32(cursor_normal + 12);

         DEBUG_WRAP(printf("frag_off = 0x%04x, total_len = 0x%04x\n", frag_off, total_len));

         if((frag_off < 0x007F) && (total_len > 0x7FFF))
            return RULE_MATCH;
         else
            return RULE_NOMATCH;
      }
  
      if(*cursor_normal & 0x80) // Last option
         break;
      else {                 // Next Option   
         if(*(cursor_normal + 1) > 0) {
            cursor_normal += *(cursor_normal + 1);
         } else {
            // Zero-length rule option??  gtfo
            break;
         }
      }
   }          

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13825,
    NULL
};
*/

